/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.minimaps;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.Config;
import club.iananderson.seasonhud.impl.minimaps.CurrentMinimap;
import club.iananderson.seasonhud.impl.seasons.CurrentSeason;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.client.Anchoring;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.config.MapAtlasesClientConfig;

public class MapAtlases
implements IGuiOverlay {
    protected final int BG_SIZE = 64;
    private static final Minecraft mc = Minecraft.m_91087_();

    private static void drawStringWithLighterShadow(PoseStack poseStack, Font font, MutableComponent text, float x, float y) {
        MapAtlases.mc.f_91062_.m_92889_(poseStack, (Component)text, x + 1.0f, y + 1.0f, 0x595959);
        MapAtlases.mc.f_91062_.m_92889_(poseStack, (Component)text, x, y, 0xE0E0E0);
    }

    public static void drawScaledComponent(PoseStack context, Font font, int x, int y, MutableComponent text, float textScaling, int maxWidth, int targetWidth) {
        float textWidth = font.m_92852_((FormattedText)text);
        float scale = Math.min(1.0f, (float)maxWidth * textScaling / textWidth);
        float centerX = (float)x + (float)targetWidth / 2.0f;
        context.m_85836_();
        context.m_85837_((double)centerX, (double)(y + 4), 5.0);
        context.m_85841_(scale *= textScaling, scale, 1.0f);
        context.m_85837_((double)(-textWidth / 2.0f), -4.0, 0.0);
        MapAtlases.drawStringWithLighterShadow(context, font, text, 0.0f, 0.0f);
        context.m_85849_();
    }

    public static void drawMapComponentSeason(PoseStack poseStack, Font font, int x, int y, int targetWidth, float textScaling) {
        if (CurrentMinimap.loadedMinimap("map_atlases")) {
            MutableComponent seasonCombined = Component.m_237110_((String)"desc.seasonhud.combined", (Object[])new Object[]{CurrentSeason.getSeasonName().get(0).m_6881_().m_130948_(Common.SEASON_STYLE), CurrentSeason.getSeasonName().get(1).m_6881_()});
            float globalScale = (float)((Double)MapAtlasesClientConfig.miniMapScale.get()).doubleValue();
            MapAtlases.drawScaledComponent(poseStack, font, x, y, seasonCombined, textScaling / globalScale, targetWidth, (int)((float)targetWidth / globalScale));
        }
    }

    public static boolean shouldDraw(Minecraft mc) {
        if (CurrentMinimap.loadedMinimap("map_atlases")) {
            if (mc.f_91073_ == null || mc.f_91074_ == null) {
                return false;
            }
            if (mc.f_91066_.f_92063_) {
                return false;
            }
            if (!((Boolean)MapAtlasesClientConfig.drawMiniMapHUD.get()).booleanValue()) {
                return false;
            }
            if (((Boolean)MapAtlasesClientConfig.hideWhenInHand.get()).booleanValue() && (mc.f_91074_.m_21205_().m_150930_((Item)MapAtlasesMod.MAP_ATLAS.get()) || mc.f_91074_.m_21206_().m_150930_((Item)MapAtlasesMod.MAP_ATLAS.get()))) {
                return false;
            }
            return !MapAtlasesClient.getCurrentActiveAtlas().m_41619_();
        }
        return false;
    }

    public void render(ForgeGui gui, PoseStack seasonStack, float partialTick, int screenWidth, int screenHeight) {
        if (CurrentMinimap.loadedMinimap("map_atlases") && MapAtlases.shouldDraw(mc)) {
            float textScaling = (float)((Double)MapAtlasesClientConfig.minimapCoordsAndBiomeScale.get()).doubleValue();
            int textHeightOffset = 2;
            float globalScale = (float)((Double)MapAtlasesClientConfig.miniMapScale.get()).doubleValue();
            int actualBgSize = (int)(64.0f * globalScale);
            LocalPlayer player = MapAtlases.mc.f_91074_;
            seasonStack.m_85836_();
            seasonStack.m_85841_(globalScale, globalScale, 1.0f);
            Anchoring anchorLocation = (Anchoring)MapAtlasesClientConfig.miniMapAnchoring.get();
            int x = anchorLocation.isLeft ? 0 : (int)((float)screenWidth / globalScale) - 64;
            int y = anchorLocation.isUp ? 0 : (int)((float)screenHeight / globalScale) - 64;
            x += (int)((float)((Integer)MapAtlasesClientConfig.miniMapHorizontalOffset.get()).intValue() / globalScale);
            y += (int)((float)((Integer)MapAtlasesClientConfig.miniMapVerticalOffset.get()).intValue() / globalScale);
            if (anchorLocation.isUp && !anchorLocation.isLeft) {
                boolean hasBeneficial = false;
                boolean hasNegative = false;
                for (MobEffectInstance e : player.m_21220_()) {
                    MobEffect effect = e.m_19544_();
                    if (effect.m_19486_()) {
                        hasBeneficial = true;
                        continue;
                    }
                    hasNegative = true;
                }
                int offsetForEffects = (Integer)MapAtlasesClientConfig.activePotionVerticalOffset.get();
                if (hasNegative && y < 2 * offsetForEffects) {
                    y += 2 * offsetForEffects - y;
                } else if (hasBeneficial && y < offsetForEffects) {
                    y += offsetForEffects - y;
                }
            }
            Font font = MapAtlases.mc.f_91062_;
            if (((Boolean)Config.enableMod.get()).booleanValue()) {
                if (((Boolean)MapAtlasesClientConfig.drawMinimapCoords.get()).booleanValue()) {
                    textHeightOffset = (int)((float)textHeightOffset + 10.0f * textScaling);
                }
                if (((Boolean)MapAtlasesClientConfig.drawMinimapBiome.get()).booleanValue()) {
                    textHeightOffset = (int)((float)textHeightOffset + 10.0f * textScaling);
                }
                MapAtlases.drawMapComponentSeason(seasonStack, font, x, (int)((float)(y + 64) + (float)textHeightOffset / globalScale), actualBgSize, textScaling);
                seasonStack.m_85849_();
            }
        }
    }
}

